/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.container.ContainerWorkbenchTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWorkbenchTFC
extends BlockWorkbench {
    private static final Map<Tree, BlockWorkbenchTFC> MAP = new HashMap<Tree, BlockWorkbenchTFC>();
    public final Tree wood;

    public static BlockWorkbenchTFC get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public BlockWorkbenchTFC(Tree wood) {
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.wood = wood;
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f).func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        OreDictionaryHelper.register((Block)this, "workbench");
        OreDictionaryHelper.register((Block)this, "crafting", "table", "wood");
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, @Nonnull BlockPos pos, IBlockState state, @Nullable EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || playerIn == null) {
            return true;
        }
        playerIn.func_180468_a((IInteractionObject)new InterfaceCraftingTable(this, worldIn, pos));
        playerIn.func_71029_a(StatList.field_188062_ab);
        return true;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class InterfaceCraftingTable
    implements IInteractionObject {
        private final BlockWorkbenchTFC workbenchTFC;
        private final World world;
        private final BlockPos position;

        public InterfaceCraftingTable(BlockWorkbenchTFC workbenchTFC, World worldIn, BlockPos pos) {
            this.workbenchTFC = workbenchTFC;
            this.world = worldIn;
            this.position = pos;
        }

        public String func_70005_c_() {
            return "crafting_table";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.workbenchTFC.func_149739_a() + ".name", new Object[0]);
        }

        public Container func_174876_a(InventoryPlayer inv, EntityPlayer player) {
            return new ContainerWorkbenchTFC(inv, this.world, this.position, this.workbenchTFC);
        }

        public String func_174875_k() {
            return "minecraft:crafting_table";
        }
    }
}

